//Lid Window.scad;

//The lid is 
//suitable for an Arduino UNO,
//with an Adafruit TFT on top,
//and has a window for access 
//to the touch screen of the TFT;

//The window has a chamfered edge, 
//so has two X dimensions and 
//two Y dimensions; 
//The dimensions are the inner sizes;
//The outer sizes are computed by adding 
//the size of the chamfer, remembering that 
//it is present on both sides;

include <UNO_Dimensions.scad>

module LidWindow()
{

echo("Begin LidWindow");
    
WindowX = 59;
WindowY = 45;
WindowChamfer = 2;

//The constant (39) below was 42, 
//but that put the window 
//too far to the right;
WindowDeltaX = 39 -WallInnerX/2;
WindowDeltaY = 0;
WindowDeltaZ = WallZ -WallThickness/2 +Fuzz;

ScaleX = (WindowX +2*WindowChamfer)/WindowX;
ScaleY = (WindowY +2*WindowChamfer)/WindowY;

translate([WindowDeltaX, WindowDeltaY, 
    WindowDeltaZ])
    {
    translate([0, 0, 1])
    linear_extrude(height=WindowChamfer, 
        center=false, 
        scale=[ScaleX, ScaleY])
    square([WindowX, WindowY], center=true);

    translate([0, 0, WallThickness/2])
    cube([WindowX, WindowY, 2*WallThickness], 
        center =true);
    }

}
//
